/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY.                         *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.  Contact information: bergmark@cs.cornell.edu     *
 ******************************************************************************/

package cnrg.itx.signal.SignalEvent;

import java.net.*;

import cnrg.itx.datax.*;
import cnrg.itx.signal.*;
import cnrg.itx.ds.*;

/** This class represents an event generated when an invitation to hangup a call is received.
 */
public class HangupSignalEvent extends SignalEvent
{
	/** Default Constructor
	 * 
	 * @param ip is the InvitePacket received
	 */
	public HangupSignalEvent(InvitePacket ip){
		this(ip, null);
	}
	
	/** Constructor
	 * 
	 * @param ip is the InvitePacket received
	 * @param sc is the SignalConnection to hangup
	 */
	public HangupSignalEvent(InvitePacket ip, SignalConnection sc){
		super(ip, sc);
	}	
}
